using System.Collections.Generic;
using TMPro;
using UnityEngine;
using UnityEngine.UI;

public class DialogueUI : MonoBehaviour {
	
	public TMP_Text label;
	public TMP_Text npcName;
	public Image npcPortrait; //move portrait to dialogue line
	public RectTransform choicePanel;
	public ChoiceUI choiceUIPrefab;

	public Dialogue currentDialogue;
	public GameObject continueButton;
	public Button continueB;
	public GameObject endButton;

	List<ChoiceUI> currentChoices = new List<ChoiceUI>();

	void Start() {
		//OnDialogueEnded();
	}

	public void setNpcName(string name)
	{
		npcName.text = name;
	}

	public void setNpcPortrait(Sprite portrait)
	{
		npcPortrait.sprite = portrait;
	}
	
	public void DisplayDialogue( Dialogue dialogueToDisplay ) {
		currentDialogue = dialogueToDisplay;
		DisplayDialogueLine( dialogueToDisplay.GetNextLine() );
	}

	void DisplayPortrait(DialogueLine dialogueLine) {
		setNpcPortrait(dialogueLine.emotion);
	}
	
	async Awaitable DisplayDialogueLine( DialogueLine dialogueLine ) {
		
		if (dialogueLine.emotion != null)
		{
			DisplayPortrait(dialogueLine);
		}
		
		setNpcName(dialogueLine.name)      ;
		await PrintText( dialogueLine.GetNextText(), dialogueLine );
	}

	public void Continue() {
		continueButton.SetActive( false );
		DisplayDialogueLine( currentDialogue.currentLine );
	}

	async Awaitable ChooseChoice( DialogueChoice choiceToChoose ) {
		choiceToChoose.isChosen = true;
		continueButton.SetActive( false );
		for ( int index = 0; index < choicePanel.childCount; index++ ) {
			Destroy( choicePanel.GetChild( index ).gameObject );
		}
		
		await DisplayDialogueLine( choiceToChoose.GetNextDialogueLine() );
	}

	public void EndDialogue() {
		
		continueButton.SetActive( false );
		endButton.SetActive( false );
		
		label.text = "";
		
		for( int index = 0; index < choicePanel.childCount; index++ ) {
			Destroy( choicePanel.GetChild( index ).gameObject );
		}
		OnDialogueEnded();
	}

	void OnDialogueEnded() {
		currentDialogue.Finish();
		currentDialogue = null;
		gameObject.SetActive(false);
	}

	async Awaitable PrintText( string text, DialogueLine dialogueLine ) {
		string currentText = "";
		if (text != null)
		{
			for (int index = 0; index < text.Length; index++)
			{
				currentText += text[index];
				label.text = currentText;

				await Awaitable.WaitForSecondsAsync(0.01f);
			}
		}
		
		currentDialogue.currentLine = dialogueLine;
		
		if( dialogueLine.IsFinished() ) {
			endButton.SetActive( true );
			foreach( var choice in dialogueLine.choices ) {
				var choiceInstance = Instantiate( choiceUIPrefab, choicePanel, false );
				choiceInstance.label.text = choice.GetChoiceText();
				choiceInstance.button.onClick.AddListener( () => ChooseChoice( choice ) );
			}
		}
		else {
			continueButton.SetActive( true );
			endButton.SetActive( true );
		}
	}
}
