using System;
using UnityEngine;
using UnityEngine.InputSystem;
using System.Collections;

public class DialogueTrigger : MonoBehaviour {
    public DialogueUI dialogueUI;     
    public Dialogue npcDialogue;
    public Sprite npcPortrait;
    public GameObject alert;

    private float interactionRadius = 1f;
    private bool playerInRange;
    private bool inProgress;


    private void Awake()
    {
        alert = GameObject.FindGameObjectWithTag("Alert").gameObject;
        alert = alert.transform.GetChild(0).gameObject;
    }

    void Update() {
        if( UIManager.current.isOpen ) return;
        
        CheckPlayerInRange();
   
        if (playerInRange && InputSystem.actions["Interact"].WasPressedThisFrame() && !inProgress) {
            Debug.Log( $"Entering dialogue " );
            StartDialogue();
            inProgress = true;
        }
    }
    
    public void UpdateToInventory()
    {
        if (gameObject.CompareTag("Interact")) {
            GameObject.FindGameObjectWithTag("Player").GetComponent<InventorySystem>().addInventory(gameObject);
            gameObject.GetComponent<SpriteRenderer>().enabled = false;
            gameObject.GetComponent<Collider2D>().enabled = false;
            gameObject.GetComponent<DialogueTrigger>().enabled = false;

        }
            /*|| gameObject.CompareTag("Market"))
        {

        }*/
        else if (gameObject.CompareTag("Cash"))
        {
            GameObject.FindGameObjectWithTag("Player").GetComponent<PlayerController>().cash += gameObject
                .GetComponent<money>().value;
            gameObject.GetComponent<SpriteRenderer>().enabled = false;
            gameObject.GetComponent<Collider2D>().enabled = false;
            gameObject.GetComponent<DialogueTrigger>().enabled = false;
        }
    }
    
    public void setAlert()
    {
        alert.SetActive(true);
    }
    
    public void ridAlert()
    {
        alert.SetActive(false);
    }
        
    private void CheckPlayerInRange() {
        Collider2D collider = Physics2D.OverlapCircle(transform.position, interactionRadius); 
        bool playerDetected = false;

        //foreach (Collider2D collider in colliders) {
        if (collider != null && collider.GetComponent<PlayerController>() != null) {
                playerDetected = true;
                if (!playerInRange) {
                    playerInRange = true;
                    setAlert();
                    Debug.Log("Press E to start dialogue");
                }
        }
        if (!playerDetected && playerInRange) {
            playerInRange = false;
            ridAlert();
            EndDialogue();
        }
    }
    

    private void StartDialogue() {
        if (dialogueUI != null) {
            ridAlert();
            dialogueUI.gameObject.SetActive(true);
            dialogueUI.setNpcPortrait(npcPortrait);
            dialogueUI.setNpcName(npcDialogue.name);
            dialogueUI.DisplayDialogue(npcDialogue);
        }
    }

    private void EndDialogue() {
        if (dialogueUI != null && dialogueUI.gameObject.activeSelf) {
            npcDialogue.currentLine = npcDialogue.dialogueLines[0];
            dialogueUI.EndDialogue();
            dialogueUI.gameObject.SetActive(false);
        }
        inProgress = false;
    }
}