using System;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UIElements;

public class DialogueLine : MonoBehaviour, Saveable
{
    [SerializeField]
    private List<string> dialogueText;

    public List<DialogueChoice> choices;
    public List<Condition> conditions;
    public List<Consequence> consequences;
    public Sprite emotion;
    [NonSerialized] public int currentTextIndex;

    private void Awake() {
        if (dialogueText == null) dialogueText = new List<string>();
        if (conditions == null) conditions = new List<Condition>();
        if (consequences == null) consequences = new List<Consequence>();

        // Collect only immediate children
        for (int i = 0; i < transform.childCount; i++) {
            var child = transform.GetChild(i);
            var choice = child.GetComponent<DialogueChoice>();
            if (choice != null && !choices.Contains(choice)) {
                choices.Add(choice);
            }
        }
    }


    public bool IsFinished() => currentTextIndex == dialogueText.Count;

    public string GetNextText()
    {
        if (currentTextIndex < dialogueText.Count)
        {
            return dialogueText[currentTextIndex++];
        }
        else
        {
            return null;  
        }
    }

    public bool IsFullyDisplayed()
    {
        return currentTextIndex >= dialogueText.Count;
    }

    public void ResetLine()
    {
        currentTextIndex = 0;
    }

    public bool ConditionsPass() {
        foreach( var condition in conditions ) {
            Debug.Log(condition);
            if( !condition.Evaluate() ) return false;
        }

        return true;
    }

    public string Save()
    {
        var saved = new Record
        {
            currentTextIndex = this.currentTextIndex,
        };

        return JsonUtility.ToJson(saved);
    }

    public void Load(string json)
    {

        var loaded = JsonUtility.FromJson<Record>(json);

        this.currentTextIndex = loaded.currentTextIndex;
    }

    [Serializable]
    public class Record
    {
        public int currentTextIndex;

    }
}