using System.Collections.Generic;
using UnityEngine;
using System;

public class DialogueChoice : MonoBehaviour, Saveable
{
    [SerializeField] 
    private string choiceText; 

    [SerializeField]
    private List<DialogueLine> transitionDialogueLines; 

    [SerializeField]
    private List<Condition> conditions;

    public bool isChosen;

    private void Awake()
    {
        if (transitionDialogueLines == null) transitionDialogueLines = new List<DialogueLine>();
        if (conditions == null) conditions = new List<Condition>();
        
        for( int index = 0; index < transform.childCount; index++ ) {
            var childLine = transform.GetChild( index ).GetComponent<DialogueLine>();
            if( childLine && !transitionDialogueLines.Contains( childLine ) ) transitionDialogueLines.Add( childLine );
        }
    }
    
    
    public string GetChoiceText()
    {
        return choiceText;
    }

    public bool AreConditionsMet()
    {
        foreach (Condition condition in conditions)
        {
            if (!condition.Evaluate())
                Debug.Log(condition);
                return false;
        }
        return true;
    }

    public DialogueLine GetNextDialogueLine()
    {
        foreach (DialogueLine line in transitionDialogueLines) {
            // if (line != null && line.IsFullyDisplayed()) continue; 
            if( CheckLineConditions(line) ) {
                //isChosen = true;
                return line;
            }
        }
        return null;
    }

    private bool CheckLineConditions(DialogueLine line)
    {
        foreach (Condition condition in line.conditions)
        {
            Debug.Log(condition);
            if (!condition.Evaluate())
                return false;
        }
        return true;
    }

    public string Save()
    {
        var saved = new Record
        {
            isChosen = this.isChosen,
        };

        return JsonUtility.ToJson(saved);
    }

    public void Load(string json)
    {

        var loaded = JsonUtility.FromJson<Record>(json);

        this.isChosen = loaded.isChosen;
    }

    [Serializable]
    public class Record
    {
        public bool isChosen;
    }
}
