using System;
using System.Collections.Generic;
using UnityEngine;

public class Dialogue : MonoBehaviour
{
    public List<DialogueLine> dialogueLines;

    public DialogueLine currentLine;

    [SerializeField] private GameObject pickedOption;
    [SerializeField] private GameObject killedOption;
    [SerializeField] private GameObject goodOption;
    [SerializeField] private GameObject lem;
    [SerializeField] private GameObject requireItem;
    public int goodReward;

    void Awake() {
        for( int index = 0; index < transform.childCount; index++ ) {
            var childLine = transform.GetChild( index ).GetComponent<DialogueLine>();
            if( childLine && !dialogueLines.Contains( childLine ) ) dialogueLines.Add( childLine );
        }
    }
    
    public void SetCurrentLine(DialogueLine line)
    {
        currentLine = line;
    }

    public void Finish() {
        foreach( var line in dialogueLines ) {
            line.currentTextIndex = 0;
        }
        if (pickedOption != null && pickedOption.activeSelf && pickedOption.GetComponent<DialogueChoice>().isChosen)
        {
            transform.parent.gameObject.GetComponent<DialogueTrigger>().UpdateToInventory();
        }
        if(killedOption != null && killedOption.activeSelf && killedOption.GetComponent<DialogueChoice>().isChosen)
        {
            lem.gameObject.GetComponent<Shooting>().totalAmmo--;
            transform.parent.gameObject.SetActive(false);
        }

        if (goodOption != null && goodOption.activeSelf && goodOption.GetComponent<DialogueChoice>().isChosen)
        {
            lem.gameObject.GetComponent<InventorySystem>().gcList
    [lem.gameObject.GetComponent<InventorySystem>().gcList.IndexOf(requireItem)] = null;
            lem.gameObject.GetComponent<InventorySystem>().itemIndex--;
            lem.gameObject.GetComponent<PlayerController>().cash += goodReward;
            transform.parent.gameObject.SetActive(false);
        }

        SetCurrentLine( null );
    }
    
    public DialogueLine GetNextLine()
    {
        foreach( var line in dialogueLines ) {
            if( line.ConditionsPass() ) {
                Debug.Log(line.gameObject);
                currentLine = line;
                return currentLine;
            }
        }

        return null;
    }

    private void ExecuteConsequences(List<Consequence> consequences)
    {
        foreach (Consequence consequence in consequences)
        {
            consequence.Execute();
        }
    }

}
